/*******************************************
 **  EMUTAG SDK USER CODE BLANK TEMPLATE  **
 *******************************************/

#include <avr/io.h>
#include "main.h"

// OTHER HEADER FILES, INCLUSION FILES, DEFINES, MACROS, GLOBAL VARIABLES, ETC. HERE

/* FUNCTIONS */

/*  user_init() : Called from main code once at boot time. Can be used to initialize memory.
 *              : This function is required to be present. Leave empty if not used.
 */
void user_init(void);

/*  user_pwr_cycle() : Called from main code at boot time and when carrier is lost for >100 usec. Can be used to reset tag state.
 *                   : This function is required to be present. Leave empty if not used.
 */
void user_pwr_cycle(void);

/*  user_frame_end() : Called from main code after optionally sending response frame.
 *                   : Can be used for operations longer than frame response timeout, such as writing Flash or EEPROM.
 *                   : This function is required to be present. Leave empty if not used. Keep as short as possible in locked mode.
 */
void user_frame_end(void);

/*  user_proc() : Called from main code when an incoming message has been received and stored in rx_buf[].
 *
 *  rx_bytes      = number of complete bytes stored in rx_buf[]
 *  rx_bits       = number of additional bits received if the last byte is incomplete
 *  rx_bits_total = rx_bytes * 9 + rx_bits, cached for faster comparisons
 *  __attribute__((OS_main)) tells the compiler not to save any registers on stack, as main code reloads everything
 */
void user_proc(uint8_t rx_bytes, uint8_t rx_bits, uint8_t rx_bits_total) __attribute__((OS_main));

// OTHER FUNCTIONS HERE

void user_init(void) {
	
	// INITIALIZATION CODE HERE
	
}

void user_pwr_cycle(void) {
	
	// RESET TAG STATE MACHINE HERE
	
}

void user_frame_end(void) {
	
	// LONG OPERATIONS (5 ms or more) HERE
	
}

void user_proc(uint8_t rx_bytes, uint8_t rx_bits, uint8_t rx_bits_total) {
	
	// MESSAGE PROCESSING CODE HERE
	
	// code execution time should fit into timing constraints for timely response
	// response is aligned to 9-bit character frames
	// if timing is not met for a response frame, the response will be transmitted from the next frame
	
	// since SDK v3, calling reply(uint8_t* tx_start, uint8_t tx_bits, uint8_t tx_len) is optional
	// it is strongly recommended to return as soon as possible after calling reply()
	
}	

